/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.ntfy;

import com.ibm.hwmca.base.ntfy.NotificationConstants;
import com.ibm.hwmca.base.ntfy.NotificationMessageRes;
import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.system.NullContextException;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskMessage;
import com.ibm.ui.framework.ValueDescriptor;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public class EditTimePanelBean
extends PanelBean
implements NotificationConstants {
    private static final String TRACE_MASKT = "XNTYETPT";
    private static final String TRACE_MASKF = "XNTYETPF";
    private static final String TRACE_MASKD = "XNTYETPD";
    private String m_sName;
    private String m_sDesc;
    private transient ItemDescriptor[] m_idDaysTable;
    private transient ColumnDescriptor[] m_cdDaysTableStructure;
    private int[] m_iDaysTableSelection;
    private transient ValueDescriptor[] m_cdTimeToggleChoice;
    private String[] m_sTimeToggleChoiceSelection;
    private transient ValueDescriptor[] m_cdDateToggleChoice;
    private String[] m_sDateToggleChoiceSelection;
    private Calendar m_cStartDate;
    private Calendar m_cEndDate;
    private Calendar m_cStartTime;
    private Calendar m_cEndTime;
    private Map data;
    public static final String TASKLET_DATA_MAP = "TaskletDataMap";
    public static final String DATA_MAP_NAME = "DataMapUserName";
    public static final String DATA_MAP_DESC = "DataMapDesc";
    public static final String DATA_MAP_DAYS = "DataMapDays";
    public static final String DATA_MAP_LIMIT_DAY = "DataMapLimitDay";
    public static final String DATA_MAP_LIMIT_DAY_START = "DataMapLimitDayStart";
    public static final String DATA_MAP_LIMIT_DAY_END = "DataMapLimitDayEnd";
    public static final String DATA_MAP_LIMIT_TIME = "DataMapLimitTime";
    public static final String DATA_MAP_LIMIT_TIME_START = "DataMapLimitTimeStart";
    public static final String DATA_MAP_LIMIT_TIME_END = "DataMapLimitTimeEnd";
    public static final String MONDAY = "EditTimePanel.Monday.VALUE";
    public static final String TUESDAY = "EditTimePanel.Tuesday.VALUE";
    public static final String WEDNESDAY = "EditTimePanel.Wednesday.VALUE";
    public static final String THURSDAY = "EditTimePanel.Thursday.VALUE";
    public static final String FRIDAY = "EditTimePanel.Friday.VALUE";
    public static final String SATURDAY = "EditTimePanel.Saturday.VALUE";
    public static final String SUNDAY = "EditTimePanel.Sunday.VALUE";
    public static final String[] WEEK = new String[]{"EditTimePanel.Sunday.VALUE", "EditTimePanel.Monday.VALUE", "EditTimePanel.Tuesday.VALUE", "EditTimePanel.Wednesday.VALUE", "EditTimePanel.Thursday.VALUE", "EditTimePanel.Friday.VALUE", "EditTimePanel.Saturday.VALUE"};
    private String[] weekStrings = new String[WEEK.length];
    private static final String TIME_TOGGLE_CHOICE = "TimeToggleChoice";
    private static final String TIME_TOGGLE = "TimeToggle";
    private static final String DATE_TOGGLE_CHOICE = "DateToggleChoice";
    private static final String DATE_TOGGLE = "DateToggle";
    private static final String START_DATE = "StartDate";
    private static final String END_DATE = "EndDate";
    private static final String START_TIME = "StartTime";
    private static final String END_TIME = "EndTime";
    private static final String DAYS_TABLE = "DaysTable";
    private static final String RES_NAME = "com.ibm.hwmca.base.ntfy.res.NotificationRes";

    public void setTimeToggleChoiceSelection(String[] selected) throws IllegalUserDataException {
        this.m_sTimeToggleChoiceSelection = selected;
        if (selected.length == 1) {
            this.userTaskManager.setEnabled(this.getMountPrefix() + START_TIME, true);
            this.userTaskManager.setEnabled(this.getMountPrefix() + END_TIME, true);
        } else {
            this.userTaskManager.setEnabled(this.getMountPrefix() + START_TIME, false);
            this.userTaskManager.setEnabled(this.getMountPrefix() + END_TIME, false);
        }
    }

    public void setDateToggleChoiceSelection(String[] selected) throws IllegalUserDataException {
        this.m_sDateToggleChoiceSelection = selected;
        if (selected.length == 1) {
            this.userTaskManager.setEnabled(this.getMountPrefix() + START_DATE, true);
            this.userTaskManager.setEnabled(this.getMountPrefix() + END_DATE, true);
        } else {
            this.userTaskManager.setEnabled(this.getMountPrefix() + START_DATE, false);
            this.userTaskManager.setEnabled(this.getMountPrefix() + END_DATE, false);
        }
    }

    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACE_MASKT, "-> panelAction()");
        String command = event.getActionCommand();
        if (command == null || command.equals("CANCEL")) {
            command = this.getMountPrefix() + "CancelButton";
        }
        this.userTaskManager.storeAllElements();
        this.userTaskManager.storeElement(this.getMountPrefix() + "Name");
        PanelTaskletRequest request = new PanelTaskletRequest(this.getClass().getName() + this.getMountPrefix());
        request.setData("CommandSource", "EditTimePanel");
        request.setData("CommandName", command);
        request.setData(DATA_MAP_NAME, this.m_sName);
        request.setData(DATA_MAP_DESC, this.m_sDesc);
        request.setData(DATA_MAP_DAYS, this.m_iDaysTableSelection);
        if (this.m_sDateToggleChoiceSelection != null && this.m_sDateToggleChoiceSelection.length == 1) {
            request.setData(DATA_MAP_LIMIT_DAY, Boolean.TRUE);
            request.setData(DATA_MAP_LIMIT_DAY_START, this.m_cStartDate);
            request.setData(DATA_MAP_LIMIT_DAY_END, this.m_cEndDate);
        }
        if (this.m_sTimeToggleChoiceSelection != null && this.m_sTimeToggleChoiceSelection.length == 1) {
            request.setData(DATA_MAP_LIMIT_TIME, Boolean.TRUE);
            request.setData(DATA_MAP_LIMIT_TIME_START, this.m_cStartTime);
            request.setData(DATA_MAP_LIMIT_TIME_END, this.m_cEndTime);
        }
        if ((request.getData("CommandName").equals(this.getMountPrefix() + "OKButton") || request.getData("CommandName").equals(this.getMountPrefix() + "ApplyButton")) && (this.m_sName == null || this.m_sName.trim().equals(""))) {
            TaskMessage tm = new TaskMessage(this.userTaskManager, new NotificationMessageRes().getString("ntfy.error.blankname"), 1);
            tm.invoke();
            this.userTaskManager.setValue(this.getMountPrefix() + "Name", "");
            this.m_sName = "";
        } else {
            this.postTaskletRequest(request);
        }
        Trace.trace(TRACE_MASKT, "<- panelAction()");
    }

    public void verifyChanges() throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<> verifyChanges()");
    }

    public void save() {
        Trace.trace(TRACE_MASKT, "<> save()");
    }

    public void prepare() {
        Boolean dateb;
        Trace.trace(TRACE_MASKT, "-> prepare()");
        if (!this.m_sName.equals("")) {
            this.userTaskManager.setReadOnly(this.getMountPrefix() + "Name", true);
        }
        if ((dateb = (Boolean)this.data.get(DATA_MAP_LIMIT_DAY)) == null) {
            dateb = Boolean.FALSE;
        }
        this.m_cdDateToggleChoice = new ValueDescriptor[1];
        this.m_cdDateToggleChoice[0] = new ValueDescriptor(this.getMountPrefix() + "datetoggle", "foo");
        if (dateb.booleanValue()) {
            this.m_sDateToggleChoiceSelection = new String[]{this.getMountPrefix() + DATE_TOGGLE};
            this.userTaskManager.setEnabled(this.getMountPrefix() + START_DATE, true);
            this.userTaskManager.setEnabled(this.getMountPrefix() + END_DATE, true);
        } else {
            this.m_sDateToggleChoiceSelection = new String[0];
            this.userTaskManager.setEnabled(this.getMountPrefix() + START_DATE, false);
            this.userTaskManager.setEnabled(this.getMountPrefix() + END_DATE, false);
        }
        this.userTaskManager.refreshElement(this.getMountPrefix() + DATE_TOGGLE);
        this.userTaskManager.refreshElement(this.getMountPrefix() + START_DATE);
        this.userTaskManager.refreshElement(this.getMountPrefix() + END_DATE);
        Boolean timeb = (Boolean)this.data.get(DATA_MAP_LIMIT_TIME);
        if (timeb == null) {
            timeb = Boolean.FALSE;
        }
        this.m_cdTimeToggleChoice = new ValueDescriptor[1];
        this.m_cdTimeToggleChoice[0] = new ValueDescriptor(this.getMountPrefix() + "timetoggle", "foo");
        if (timeb.booleanValue()) {
            this.m_sTimeToggleChoiceSelection = new String[]{this.getMountPrefix() + TIME_TOGGLE};
            this.userTaskManager.setEnabled(this.getMountPrefix() + START_TIME, true);
            this.userTaskManager.setEnabled(this.getMountPrefix() + END_TIME, true);
        } else {
            this.m_sTimeToggleChoiceSelection = new String[0];
            this.userTaskManager.setEnabled(this.getMountPrefix() + START_TIME, false);
            this.userTaskManager.setEnabled(this.getMountPrefix() + END_TIME, false);
        }
        this.userTaskManager.refreshElement(this.getMountPrefix() + TIME_TOGGLE);
        this.userTaskManager.refreshElement(this.getMountPrefix() + START_TIME);
        this.userTaskManager.refreshElement(this.getMountPrefix() + END_TIME);
        int[] days = (int[])this.data.get(DATA_MAP_DAYS);
        if (days != null) {
            this.userTaskManager.setSelectedRows(this.getMountPrefix() + DAYS_TABLE, days);
        }
        Trace.trace(TRACE_MASKT, "<- prepare()");
    }

    public void load() {
        ClientUserContext userContext = null;
        try {
            userContext = ClientUserContext.getUserContext();
        }
        catch (NullContextException e) {
            userContext = null;
        }
        if (this.data != null) {
            this.m_sName = (String)this.data.get(DATA_MAP_NAME);
            this.m_sDesc = (String)this.data.get(DATA_MAP_DESC);
            this.m_cStartDate = (Calendar)this.data.get(DATA_MAP_LIMIT_DAY_START);
            this.m_cEndDate = (Calendar)this.data.get(DATA_MAP_LIMIT_DAY_END);
            this.m_cStartTime = (Calendar)this.data.get(DATA_MAP_LIMIT_TIME_START);
            this.m_cEndTime = (Calendar)this.data.get(DATA_MAP_LIMIT_TIME_END);
        } else {
            this.data = new HashMap();
        }
        if (this.m_sName == null) {
            this.m_sName = "";
        }
        if (this.m_sDesc == null) {
            this.m_sDesc = "";
        }
        if (this.m_cStartDate == null) {
            this.m_cStartDate = userContext != null ? Calendar.getInstance(userContext.getTimeZone(), userContext.getLocale()) : Calendar.getInstance();
        }
        if (this.m_cEndDate == null) {
            this.m_cEndDate = userContext != null ? Calendar.getInstance(userContext.getTimeZone(), userContext.getLocale()) : Calendar.getInstance();
        }
        if (this.m_cStartTime == null) {
            this.m_cStartTime = userContext != null ? Calendar.getInstance(userContext.getTimeZone(), userContext.getLocale()) : Calendar.getInstance();
        }
        if (this.m_cEndTime == null) {
            this.m_cEndTime = userContext != null ? Calendar.getInstance(userContext.getTimeZone(), userContext.getLocale()) : Calendar.getInstance();
        }
    }

    public void setData(Map data) {
        this.data = data;
    }

    public int getDaysTableRowCount() {
        return this.weekStrings.length;
    }

    public ItemDescriptor[] getDaysTableRowAt(int index) {
        if (this.weekStrings[index] == null) {
            ResourceBundle res = ResourceBundle.getBundle(RES_NAME);
            for (int i = 0; i < WEEK.length; ++i) {
                this.weekStrings[i] = res.getString(WEEK[i]);
            }
        }
        return new ItemDescriptor[]{new ItemDescriptor(this.getMountPrefix() + WEEK[index], this.weekStrings[index])};
    }

    public String getName() {
        return this.m_sName;
    }

    public void setName(String s) throws IllegalUserDataException {
        this.m_sName = s;
    }

    public String getDesc() {
        return this.m_sDesc;
    }

    public void setDesc(String s) throws IllegalUserDataException {
        this.m_sDesc = s;
    }

    public Calendar getStartDate() {
        return this.m_cStartDate;
    }

    public void setStartDate(Calendar c) throws IllegalUserDataException {
        this.m_cStartDate = c;
    }

    public Calendar getEndDate() {
        return this.m_cEndDate;
    }

    public void setEndDate(Calendar c) throws IllegalUserDataException {
        this.m_cEndDate = c;
    }

    public Calendar getStartTime() {
        return this.m_cStartTime;
    }

    public void setStartTime(Calendar c) throws IllegalUserDataException {
        this.m_cStartTime = c;
    }

    public Calendar getEndTime() {
        return this.m_cEndTime;
    }

    public void setEndTime(Calendar c) throws IllegalUserDataException {
        this.m_cEndTime = c;
    }

    public String[] getTimeToggleChoiceSelection() {
        return this.m_sTimeToggleChoiceSelection;
    }

    public String[] getDateToggleChoiceSelection() {
        return this.m_sDateToggleChoiceSelection;
    }

    public ColumnDescriptor[] getDaysTableRowStructure() {
        return this.m_cdDaysTableStructure;
    }

    public int getDaysTableRowStatus() {
        return 3;
    }

    public void setDaysTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idDaysTable = items;
    }

    public int[] getDaysTableSelection() {
        return this.m_iDaysTableSelection;
    }

    public void setDaysTableSelection(int[] selected) throws IllegalUserDataException {
        this.m_iDaysTableSelection = selected;
    }
}

